<?php
if ( ! defined('ABSPATH') ) exit;

function acw_admin_menu() {
    add_menu_page(
        __('Aurora Chat', 'aurora-chat-widget'),
        __('Aurora Chat', 'aurora-chat-widget'),
        'manage_options',
        'acw-admin',
        'acw_render_admin_screen',
        'dashicons-format-chat',
        80
    );
}
add_action('admin_menu', 'acw_admin_menu');

function acw_admin_notice_success() {
    if (isset($_GET['settings-updated']) && $_GET['settings-updated']) {
        echo '<div class="notice notice-success is-dismissible" style="border-left-color:#00ffff"><p><strong>✅ ' .
             esc_html__('Configuración guardada correctamente.', 'aurora-chat-widget') .
             '</strong></p></div>';
    }
}
add_action('admin_notices', 'acw_admin_notice_success');

function acw_render_admin_screen() {
    $o = acw_get_settings();
    ?>
    <div class="wrap">
      <h1><span class="dashicons dashicons-format-chat"></span> <?php _e('Aurora Chat · Ajustes', 'aurora-chat-widget'); ?></h1>
      <p><?php _e('Conectá tu flujo de n8n y personalizá el widget. Guardá los cambios y recargá tu sitio para verlos reflejados.', 'aurora-chat-widget'); ?></p>

      <style>
        .wrap {
          background: #0b1220;
          color: #eaffff;
          padding: 28px 30px;
          border-radius: 12px;
          border: 1px solid rgba(0,255,255,0.2);
          box-shadow: 0 0 22px rgba(0,255,255,0.2);
          max-width: 980px;
        }
        .wrap h1 { color: #00ffff; text-shadow: 0 0 6px #00ffff; }
        .form-table th { color: #eaffff; width: 220px; vertical-align: top; }
        .form-table input[type="text"], .form-table textarea, .form-table select {
          width: 100%;
          max-width: 620px;
          border-radius: 8px;
          border: 1px solid rgba(0,255,255,0.25);
          background: rgba(0,0,0,0.45);
          color: #eaffff;
          padding: 10px 12px;
        }
        .form-table textarea { min-height: 140px; font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", monospace; }
        .description { color: #a9ffff; opacity: .85; }
        .button-primary {
          background: #00ffff !important; border: 0 !important; color: #001419 !important;
          padding: 10px 18px; border-radius: 8px; box-shadow: 0 0 16px rgba(0,255,255,.45);
        }
        .button-primary:hover { box-shadow: 0 0 22px rgba(0,255,255,.7); }
        .acw-field-sep { border-top: 1px solid rgba(0,255,255,.2); margin: 24px 0; }
        code.inline { background: rgba(255,255,255,0.06); padding: 2px 6px; border-radius: 6px; }
      </style>

      <?php settings_errors(); ?>

      <form method="post" action="options.php">
        <?php
          settings_fields('acw_options_group');
          do_settings_sections('acw_options_group');
        ?>
        <table class="form-table" role="presentation">
          <tr>
            <th scope="row"><label for="acw_webhook"><?php _e('Webhook de n8n', 'aurora-chat-widget'); ?></label></th>
            <td>
              <input type="text" id="acw_webhook" name="acw_settings[webhook]" value="<?php echo esc_attr($o['webhook']); ?>" placeholder="https://tuinstancia.n8n.cloud/webhook/xxxx/chat" />
              <p class="description"><?php _e('Pegá la URL completa del webhook de tu flujo de n8n.', 'aurora-chat-widget'); ?></p>
            </td>
          </tr>

          <tr>
            <th scope="row"><?php _e('Modo de visualización', 'aurora-chat-widget'); ?></th>
            <td>
              <select name="acw_settings[mode]">
                <option value="overlay" <?php selected($o['mode'],'overlay'); ?>>overlay</option>
                <option value="inline"  <?php selected($o['mode'],'inline');  ?>>inline</option>
              </select>
              <p class="description"><?php _e('“overlay” muestra un botón flotante. “inline” lo inserta en un contenedor definido.', 'aurora-chat-widget'); ?></p>
            </td>
          </tr>

          <tr>
            <th scope="row"><?php _e('Posición del overlay', 'aurora-chat-widget'); ?></th>
            <td>
              <select name="acw_settings[position]">
                <?php foreach (array('bottom-right','bottom-left','top-right','top-left') as $pos): ?>
                  <option value="<?php echo esc_attr($pos); ?>" <?php selected($o['position'],$pos); ?>><?php echo esc_html($pos); ?></option>
                <?php endforeach; ?>
              </select>
              <p class="description"><?php _e('Solo se aplica en modo overlay.', 'aurora-chat-widget'); ?></p>
            </td>
          </tr>

          <tr>
            <th scope="row"><?php _e('Selector inline', 'aurora-chat-widget'); ?></th>
            <td>
              <input type="text" name="acw_settings[inline_selector]" value="<?php echo esc_attr($o['inline_selector']); ?>" placeholder="#acw-chat" />
              <p class="description"><?php _e('Para modo inline: agregá <code class="inline">&lt;div id="acw-chat"&gt;&lt;/div&gt;</code> a tu página.', 'aurora-chat-widget'); ?></p>
            </td>
          </tr>

          <tr>
            <th scope="row"><?php _e('Autocargar en todo el sitio', 'aurora-chat-widget'); ?></th>
            <td>
              <label><input type="checkbox" name="acw_settings[auto_load]" value="1" <?php checked( !empty($o['auto_load']) ); ?>/> <?php _e('Sí, mostrar automáticamente en el pie de página.', 'aurora-chat-widget'); ?></label>
            </td>
          </tr>

          <tr class="acw-field-sep"><td colspan="2"></td></tr>

          <tr>
            <th scope="row"><?php _e('Idioma por defecto', 'aurora-chat-widget'); ?></th>
            <td>
              <input type="text" name="acw_settings[default_lang]" value="<?php echo esc_attr($o['default_lang']); ?>" placeholder="en, es, fr…" />
            </td>
          </tr>

          <tr>
            <th scope="row"><?php _e('Mensajes iniciales (una línea por mensaje)', 'aurora-chat-widget'); ?></th>
            <td>
              <textarea name="acw_settings[initial_messages]" placeholder="Hola! Soy tu asistente.&#10;¿En qué puedo ayudarte?"><?php echo esc_textarea($o['initial_messages']); ?></textarea>
            </td>
          </tr>

          <tr>
            <th scope="row"><?php _e('Etiquetas de idioma (i18n)', 'aurora-chat-widget'); ?></th>
            <td>
              <p class="description"><?php _e('Personalizá los textos visibles en el chat.', 'aurora-chat-widget'); ?></p>
              <p><label>title<br><input type="text" name="acw_settings[i18n][title]" value="<?php echo esc_attr($o['i18n']['title']); ?>"></label></p>
              <p><label>subtitle<br><input type="text" name="acw_settings[i18n][subtitle]" value="<?php echo esc_attr($o['i18n']['subtitle']); ?>"></label></p>
              <p><label>inputPlaceholder<br><input type="text" name="acw_settings[i18n][inputPlaceholder]" value="<?php echo esc_attr($o['i18n']['inputPlaceholder']); ?>"></label></p>
              <p><label>getStarted<br><input type="text" name="acw_settings[i18n][getStarted]" value="<?php echo esc_attr($o['i18n']['getStarted']); ?>"></label></p>
              <p><label>typing<br><input type="text" name="acw_settings[i18n][typing]" value="<?php echo esc_attr($o['i18n']['typing']); ?>"></label></p>
            </td>
          </tr>

          <tr class="acw-field-sep"><td colspan="2"></td></tr>

          <tr>
            <th scope="row"><?php _e('Variables CSS personalizadas', 'aurora-chat-widget'); ?></th>
            <td>
              <textarea name="acw_settings[css_vars]" placeholder=":root { --chat--color--primary: #00ffff; … }"><?php echo esc_textarea($o['css_vars']); ?></textarea>
              <p class="description"><?php _e('Pegá tu bloque :root { … } para aplicar tu tema visual.', 'aurora-chat-widget'); ?></p>
            </td>
          </tr>
        </table>

        <?php submit_button(__('Guardar cambios', 'aurora-chat-widget')); ?>
      </form>

      <div class="acw-field-sep"></div>
      <p><strong>Shortcode:</strong> <code class="inline">[aurora_chat]</code></p>
      <p class="description"><?php _e('Usalo para insertar el chat inline. Para overlay, habilitá la autocarga.', 'aurora-chat-widget'); ?></p>
    </div>
    <?php
}
