<?php
if ( ! defined('ABSPATH') ) exit;

function acw_get_settings() {
    $defaults = acw_default_options();
    $opts = get_option('acw_settings', array());
    if (!is_array($opts)) $opts = array();
    return array_replace_recursive($defaults, $opts);
}

function acw_register_settings() {
    register_setting(
        'acw_options_group',
        'acw_settings',
        array(
            'type'              => 'array',
            'sanitize_callback' => 'acw_sanitize_settings',
            'default'           => acw_default_options(),
            'show_in_rest'      => false,
        )
    );
}
add_action('admin_init', 'acw_register_settings');

function acw_sanitize_settings($in) {
    $out = is_array($in) ? $in : array();

    $out['webhook']         = isset($in['webhook']) ? esc_url_raw($in['webhook']) : '';
    $out['mode']            = in_array(($in['mode'] ?? ''), array('overlay','inline'), true) ? $in['mode'] : 'overlay';
    $out['position']        = in_array(($in['position'] ?? ''), array('bottom-right','bottom-left','top-right','top-left'), true) ? $in['position'] : 'bottom-right';
    $out['auto_load']       = !empty($in['auto_load']) ? 1 : 0;
    $out['inline_selector'] = sanitize_text_field($in['inline_selector'] ?? '#acw-chat');
    $out['default_lang']    = sanitize_text_field($in['default_lang'] ?? 'en');

    $initial = isset($in['initial_messages']) ? (string)$in['initial_messages'] : '';
    $initial = str_replace(array("\r\n","\r"), "\n", $initial);
    $out['initial_messages'] = wp_kses_post($initial);

    $out['i18n'] = array(
        'title'            => sanitize_text_field($in['i18n']['title'] ?? 'Assistant'),
        'subtitle'         => sanitize_text_field($in['i18n']['subtitle'] ?? 'Chat Support'),
        'inputPlaceholder' => sanitize_text_field($in['i18n']['inputPlaceholder'] ?? 'Type your message…'),
        'getStarted'       => sanitize_text_field($in['i18n']['getStarted'] ?? 'Start chat'),
        'typing'           => sanitize_text_field($in['i18n']['typing'] ?? 'Assistant is typing…'),
    );

    $css_vars = (string)($in['css_vars'] ?? '');
    $css_vars = wp_kses($css_vars, array());
    $css_vars = preg_replace('/@import[^;]+;?/i', '', $css_vars);
    $out['css_vars'] = $css_vars;

    return $out;
}
